<?php

use app\models\active\Business;
use app\models\active\Corp;
use app\models\User;
use yii\helpers\Html;
use app\commands\Rounding;


$this->title = Yii::$app->name;
?>

    <style>

        .disabled {


            color: #666666;

        }

    </style>

    <div class="content">


        <?php if (User:: AchievementsCount()): ?>
            <br>
            <div class="feedback">
                Получено новое достижение
                <br>
                <a href="/user/achievements" class="btn btn-success">
                    Забрать награду
                </a>

            </div>

        <?php endif; ?>


        <?php if (User:: QuestCount()): ?>
            <br>
            <div class="feedback">
                Задание выполнено
                <br>
                <a href="/user/quest" class="btn btn-success">
                    Забрать награду
                </a>

            </div>

        <?php endif; ?>


        <?php if ($user->forum_reply > 0): ?>
            <div class="feedback">
                Вам ответили на форуме
                <br>
                <a href="?hide=forum" class="btn btn-success">
                    Скрыть
                </a>

                <a href="/forum/topic/<?php echo $user->forum_reply; ?>" class="btn btn-success">
                    Ответить
                </a>
            </div>

        <?php endif; ?>


        <?php if ($user->chat_reply > 0): ?>
            <div class="feedback">
                Вам ответили в чате
                <br>
                <a href="?hide=chat" class="btn btn-success">
                    Скрыть
                </a>

                <a href="/chat" class="btn btn-success">
                    Ответить
                </a>
            </div>
        <?php endif; ?>

        <?php if (isset($giftus['id'])): ?>

            <div class="feedback">
                Игрок <?php echo User:: findUser($giftus['who']); ?> отправил вам подарок
                <img src="/images/gifts/<?php echo $giftus['gift']; ?>.jpg">
                <br>
                <br>
                <a href="?hide=gift" class="btn btn-success">
                    Скрыть
                </a>
            </div>


        <?php endif; ?>

        <?php if (!empty($coming_battle)): ?>
            <div class="feedback">
                Сражение вот вот начнётся. Поспеши принять участие!
                <br>
                <br>
                <a href="/battles" class="btn btn-success">
                    Сражения
                </a>
            </div>
        <?php endif; ?>


        <?php if (isset($topic->id)): ?>
            <div class="bordered news">
                <center>
                    <div class="admin"><?php echo Html::Encode($topic->name); ?></div>
                    <a class="btni" href="/forum/topic/<?php echo $topic->id; ?>"
                       style="margin-top: 3px; width: 140px;"> Перейти к новости</a>
                    <br>
                    <a href="javascript:void(0);" class="news_hide" onclick="newsHide();">Скрыть</a>

            </div>

        <?php endif; ?>

        <br>
        <div class="blocks"><a class="btnl" id="autoup"
                               href="javascript:void(0);"
                               style="color: white;font-weight: bolder;"><span>Автопрокачка</span></a></div>
        <div class="center" id="button-business-price">
            <div class="blocks">
                <a class="btnl default" style="color: white;font-weight: bolder;" id="newbusiness"
                   href="javascript:void(0);"><span>Новый бизнес
                  <img src="/images/header/money_36.png" alt="$" width="20" height="20"> <span
                                id="business-price"></span> </span>
                    <span id="progress-bus" class="float-r"></span>
                </a>
            </div>
            <?php if ($count_b >= 15): ?>
                <div class="blocks">
                    <a class="btnl default"
                       href="javascript:void(0);" onclick="dumpBusiness();">
                        Продать все бизнесы за <img src="/images/cup.png" width="16"><?php echo $cost_b ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
    </div>
    </div>


<?php if ($invite->count() > 0): ?>

    <br>
    <?php foreach ($invite->all() as $res): ?>

        <div class="feedback">Вас приглашают вступить в корпорацию <?php echo Corp:: findCorp($res['corp']); ?>

            <button onclick="invite(<?php echo $res['id']; ?>,0);" class="btn btn-success">
                Принять
            </button>

            <button onclick="invite(<?php echo $res['id']; ?>,1);" class="btn btn-success">
                Отклонить
            </button>

        </div>

    <?php endforeach; ?>

    <br>
<?php endif; ?>


    <div class="content">
        <div class="mybusiness"></div>
    </div>

    <div class="content text-center pagination-container">
        <?= \yii\widgets\LinkPager::widget(['pagination' => $pagination]) ?>
    </div>

    <div class="mt4 content text-center">
        <a href="javascript:void(0);" onclick="BusinessView();" id="typeView" class="link-gray">
            <?php echo $user->business_view == 0 ? 'Компактный вид' : 'Обычный вид'; ?>
        </a>
    </div>


    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col blocks">
                    <a class="btnl text-center" href="/battles">
                        <img src="/images/main/battles.png" width="20">
                        Сражения
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col blocks">
                    <a class="btnl" href="/user/quest">
                        <img src="/images/main/quest.jpg" width="20"> <small>Задания
                            (<?php echo User::QuestsDoneUs(); ?> из
                            7) </small>
                    </a>
                </div>

                <div class="col blocks">
                    <a class="btnl" href="/tourney">
                        <img src="/images/cup.png" width="20">
                        Турниры (<?php echo $user->cup; ?>)
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col blocks">
                    <a class="btnl" href="/user/payment">
                        <img src="/images/ruby.png" width="20">
                        Купить рубины </a>
                </div>

                <div class="col blocks">
                    <a class="btnl" href="/user/exchange">
                        <img src="/images/header/money_36.png" width="20">
                        Обменник </a>
                </div>
            </div>
            <div class="row">
                <div class="col blocks">
                    <a class="btnl" href="/user/chests">
                        <img src="/images/main/cheest.jpg" width="20">
                        Сундуки <?php if ($user->_key > 0): ?>
                            (<?php echo $user->_key; ?>) <i class="fa fa-key"></i>
                        <?php endif; ?> </a>
                </div>

                <div class="col blocks">
                    <a class="btnl"
                       href="/rating?page=<?php echo round(User:: Rating(Yii::$app->user->id, 'income') / 10); ?>">
                        <img src="/images/main/top.png" width="20">
                        Рейтинг </a>
                </div>
            </div>
            <div class="row">
                <div class="col blocks">
                    <a class="btnl text-center" href="/premium-shop">
                        <img src="/images/main/shop.png" width="20">
                        Магазин
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col blocks">
                    <a class="btnl text-center" href="/market">
                        <img src="/images/main/market.png" width="20">
                        Аукцион
                        <?php if (!empty($journal)): ?>
                            <span class="tgreen">+</span>
                        <?php endif; ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

<?php
$script = <<< JS

function dumpBusiness(){
	swal({
        title: "Вы уверены, что хотите сбросить все бизнесы за $cost_b кубков?",
        text: "",
        buttons: {
            text: "Да",
            cancel: "Нет"
        }
    }).then(function(isConfirm) {
      if(isConfirm){
          document.location.assign(document.location.href +'?dump=true');
      }
    });
}
	
	
	function BusinessView()
	{
		
		$.getJSON('/ajax/business-view', function(data) {
		
		$('#typeView').html(data.type);
		
		MyBusiness();
		
		});
	}
	
	
	

	$('.mybusiness').html('<div class="bordered center"><i class="fa fa-spinner fa-spin"></i> Загрузка...</div>')
	 
	 function businessUp(business,col){

		
		$.getJSON('/ajax/business-up?id='+business+'&col='+col, function(data) {
        
        ///swal(data.title,  '',  data.status);
		
		MyBusiness();
		MoneyUser();
		MoneyUser();
        
		});
		
	
	
	
	 }
	 
	 
	 $('.business-view').click(function()
	 {
	     
	     $.getJSON('/ajax/news-hide');
	     
	     $('.news').hide();
	     
	 });
	 
	 
	 function invite(id,type)
	 {
		 
		 $.getJSON('/ajax/invite-user?id='+id+'&type='+type, function(data) {
		 
		 swal(data.title,  '',  data.status);
		 setTimeout(function(){
				location.reload();
			}, 1000);
			
		 });
		 
	 }
	 
	
	function MyBusiness()
	{
		$.get('/ajax/business', {page: $page}, function(data){
			$('.mybusiness').html(data);
		});
	}
	
	
	function BusinessPrice()
	{
		
		$.getJSON('/ajax/business-price', function(data) {
		
				if(data.status == 1){
				    $('#business-price').html(data.price);
					
					if(data.virib == 1){
					    
					$('#newbusiness').prop('class','btnl tgray');
					
					}else{
					    
					$('#newbusiness').prop('class','btnl tgreen');   
					    
					}
					
					
				}
					else
				{
						
					
					$('#button-business-price').fadeOut();
				
				}
		
		});
		
		$.ajaxSetup({
           async: false
         });
        var money = null;
        var price = null;
        $.getJSON('/ajax/user?type=1', function(data) {
                    money = data.money;
                });
        $.getJSON('/ajax/business-price?type=1', function(data) {
                    price = data.price;
                });
        $('#progress-bus').html(' <progress value="'+money+'" max="'+price+'" style="opacity: 0.7;"></progress>');
		
	}
	
	$('#newbusiness').click(function() {
		
		$.getJSON('/ajax/business-new', function(data) {
			
			if(data.status == 'success'){
				
				MoneyUser();
				BusinessPrice();
				MyBusiness();
				
				
			}
			
			
		
		});
		
		
	});
	
	

	
	
	$('#autoup').click(function() {
		
		$.getJSON('/ajax/auto-up', function(data) {
			
			if(data.status == 'success'){
				
				MoneyUser();
				MyBusiness();
				
				///swal('Бизнесы успешно улучшены',  '',  'success');
			}
			
			
		
		});
		
		
	});
	
	

	
	BusinessPrice();
	MyBusiness();
	
	setInterval(MyBusiness,10000);
	setInterval(BusinessPrice,10000);
	
JS;

$this->registerJs($script, $this::POS_END);